#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_HospitalLocation : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetHospitalLocationsByDivision_Pass()
		{
			DataSet dsTest = DAL.VAL.HospitalLocation.GetHospitalLocationsByDivision( UnitTestConfig.TestDivisionCode );

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(5, dsTest.Tables[0].Columns.Count, "Columns.Count");

			DataTable dtTest = dsTest.Tables[0];

			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HospitalLocationCache.LocationDivision), Common.VbecsTables.HospitalLocationCache.LocationDivision);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HospitalLocationCache.LocationIen), Common.VbecsTables.HospitalLocationCache.LocationIen);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HospitalLocationCache.LocationName), Common.VbecsTables.HospitalLocationCache.LocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HospitalLocationCache.LocationType), Common.VbecsTables.HospitalLocationCache.LocationType);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HospitalLocationCache.LastUpdateDate), Common.VbecsTables.HospitalLocationCache.LastUpdateDate);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetHospitalLocationsByDivision_Fail_1()
		{
			DAL.VAL.HospitalLocation.GetHospitalLocationsByDivision( null );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetHospitalLocationsByDivision_Fail_2()
		{
			//New caching system, prevents this failure from occuring
		}
	}
}
#endif
